//Program Title: To perform image enhancement by point operation/processing.
//Program Description: This scilab code is used to perform image enhancement using point processing techniques like Contrast Stretching, Log transform, Power Law transform, Gray level slicing(with and without background), Bit plane slicing.

//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit
//Scilab version: 6.0.1 (Tested on 64 bit version)
//Toolbox used: Image Processing and Computer Vision Toolbox (version 2.0)
//Reference book name : Digital Image Processing book (author : Rafael C.Gonzalez and Richard E.Woods)

clear;
clc;
clear all;
close;

img=imread("ip1_texture.jpeg"); // input image 1 --> ip1_texture.jpeg
figure();xname("Original image");
imshow(img);

img_gray = rgb2gray(img);
figure();xname("Grayscale image");
imshow(img_gray);

//////////////////////////////    Contrast Stretching  //////////////////////////////////////////
c = min(img_gray);
d=  max(img_gray);
a=0
b=255

MP = (b-a)/(d-c);
img_contrast = (img_gray-c).*MP+a;
figure(); xname("Contrast Stretched image");
imshow(img_contrast);

//////////////////////////////    log transform  //////////////////////////////////////////
c=0.5
[m,n]=size(img_gray);
im_double = im2double(img_gray);
for x=1:m
    for y=1:n
        img_log1(x,y) = c*log(1+ im_double(x,y))
    end
end

figure(); xname("Log transformed image: c= 0.5");
imshow(img_log1);

c=1
[m,n]=size(img_gray);
im_double = im2double(img_gray);
for x=1:m
    for y=1:n
        img_log2(x,y) = c*log(1+ im_double(x,y))
    end
end
figure(); xname("Log transformed image: c= 1");
imshow(img_log2);


c=1.5
[m,n]=size(img_gray);
im_double = im2double(img_gray);
for x=1:m
    for y=1:n
        img_log3(x,y) = c*log(1+ im_double(x,y))
    end
end
figure(); xname("Log transformed image: c= 1.5");
imshow(img_log3);

////////////////////////////////    Power Law transform  //////////////////////////////////////////

gamma = 0.5;
for x=1:m
    for y=1:n
        img_pow1(x,y) = c*(im_double(x,y))^gamma;
    end
end
figure(); xname("Power Law transformed image: gamma = 0.5");
imshow(img_pow1);

gamma = 1.5;
for x=1:m
    for y=1:n
        img_pow2(x,y) = c*(im_double(x,y))^gamma;
    end
end
figure(); xname("Power Law transformed image: gamma = 1.5");
imshow(img_pow2);

gamma = 5;
for x=1:m
    for y=1:n
        img_pow3(x,y) = c*(im_double(x,y))^gamma;
    end
end
figure(); xname("Power Law transformed image: gamma = 5");
imshow(img_pow3);

//////////////////////////////////    Gray Level Slicing (with Background)  //////////////////////////////////////////

for x=1:m
    for y=1:n
        if(img_gray(x,y)>50 & img_gray(x,y)<200)
            img_gray_with(x,y)=255;            
        else
            img_gray_with(x,y)= im_double(x,y);
        end
    end
end
figure(); xname("Gray Level Slicing with background");
imshow(img_gray_with);

////////////////////////////////    Gray Level Slicing (without Background)  //////////////////////////////////////////

for x=1:m
    for y=1:n
        if(img_gray(x,y)>50 & img_gray(x,y)<200)
            img_gray_without(x,y)=255;            
        else
            img_gray_without(x,y)= 0;
        end
    end
end
figure(); xname("Gray Level Slicing without background");
imshow(img_gray_without);

////////////////////////////////    Bit plane slicing   //////////////////////////////////////////
// here we use 'ip2_lena.jpg' as the input image to demonstrate the bit plane slicing operation in full effect

img=imread("ip2_lena.jpg"); // second input image --> 'ip2_lena.jpg'
img_gray = rgb2gray(img);

[m,n]=size(img_gray);
img_8bit = im2uint8(img_gray)
for x=1:m
    for y=1:n
        bit1(x,y) = bitget(img_8bit(x,y),1)*255;
        bit2(x,y) = bitget(img_8bit(x,y),2)*255;
        bit3(x,y) = bitget(img_8bit(x,y),3)*255;
        bit4(x,y) = bitget(img_8bit(x,y),4)*255;
        bit5(x,y) = bitget(img_8bit(x,y),5)*255;
        bit6(x,y) = bitget(img_8bit(x,y),6)*255;
        bit7(x,y) = bitget(img_8bit(x,y),7)*255;
        bit8(x,y) = bitget(img_8bit(x,y),8)*255;
    end
end

scf(20);
figure(); xname("ALL images");
var_rows = 2;
var_cols = 4;
subplot(var_rows,var_cols,1), imshow(bit8);
title('Bit Plane 7');
subplot(var_rows,var_cols,2), imshow(bit7);
title('Bit Plane 6');
subplot(var_rows,var_cols,3), imshow(bit6);
title('Bit Plane 5');
subplot(var_rows,var_cols,4), imshow(bit5);
title('Bit Plane 4');
subplot(var_rows,var_cols,5), imshow(bit4);
title('Bit Plane 3');
subplot(var_rows,var_cols,6), imshow(bit3);
title('Bit Plane 2');
subplot(var_rows,var_cols,7), imshow(bit2);
title('Bit Plane 1');
subplot(var_rows,var_cols,8), imshow(bit1);
title('Bit Plane 0');

